/*******************************************************
Filename		:  FA_REGULAR_RESULT_index.sql
Release 		:  c2.0, C2.0.1
SIR			:  1497, 1558
Description		:  create indexes for the FA_REGULAR_RESULT fact table.
Author			:  Joseph Wilson
Date			:  2/28/2003
			   6/18/2003 -- added indexes from performance_tuning script
			   7-01-2003 -- changed names from CHEM to REGULAR -JW
			   8-13-2003 -- added fk_act_medium to multi-dimensional indexes -JW
			   8-20-2003 -- comment out hmethod and hdatum indexes -JW
			   8-29-2003 -- added fk_act_medium to lat-long index -JW
			   9-02-2003 -- created independent lat-long index -JW
			   10-30-2003 -- created Blob title indexes -WN
			   01/16/04 - SIR 1586 Moved connect string to master install script -JW
			   01/26/04 - SIR 1571 Create index on FK_STN_ACT_PT -JW
Comments		:  Changed multiple indexes to bitmap, changed order of 
			   muli-dim indexes
**********************************************************/

spool FA_REGULAR_RESULT_index.log

--check where ire_date was created before
create index ire_date on FA_REGULAR_RESULT(fk_date_act_start)
tablespace storetindx
storage (initial 15M next 10M) nologging;

create index ire_acitivty_isn on FA_REGULAR_RESULT(activity_isn)
tablespace storetindx
storage (initial 15M next 10M) nologging;

--FK INDEXES
create bitmap index ire_org1 on FA_REGULAR_RESULT(fk_org)
tablespace storetindx
storage (initial 15M next 10M) nologging;

/** 08-20-2003
create index ire_mad_hmethod on FA_REGULAR_RESULT(fk_mad_hmethod)
tablespace storetindx
storage (initial 15M next 10M) nologging;

create index ire_mad_hdatum on FA_REGULAR_RESULT(fk_mad_hdatum)
tablespace storetindx
storage (initial 15M next 10M) nologging;
**/

/**
--only 429 currently used, changed to bitmap 2-25
--was deleted due to performance problems with project 3-28
create bitmap index ire_char on FA_REGULAR_RESULT(fk_char)
tablespace storetindx
storage (initial 50m next 50m) nologging;
**/

--changed to bitmap 2-25
create bitmap index ire_geo1 on FA_REGULAR_RESULT(fk_geo_state)
tablespace storetindx
storage(initial 15M next 10M) nologging;

create index ire_geo2 on FA_REGULAR_RESULT(fk_geo_county)
tablespace storetindx
storage(initial 15M next 10M) nologging;

create index ire_db_cat on FA_REGULAR_RESULT(fk_db_cat)
tablespace storetindx
storage(initial 15M next 10M) nologging;

--use to be created in another script
create index ire_station on FA_REGULAR_RESULT(fk_station)
tablespace storetindx
storage(initial 15M next 10M) nologging;


--ADDITIONAL COLUMN INDEXES
create index ire_huc on FA_REGULAR_RESULT(hydrologic_unit_code)
tablespace storetindx
storage(initial 15M next 10M) nologging;

-- Blob title index
create index ire_blob on FA_REGULAR_RESULT(blob_title)
tablespace STORETINDX
storage(initial 15m next 10m) nologging;

-- Activity Blob title index
create index ire_actblob on FA_REGULAR_RESULT(act_blob_title)
tablespace STORETINDX
storage(initial 15m next 10m) nologging;

--changed to bitmap 1/28
create bitmap index ire_oid on                             
FA_REGULAR_RESULT(organization_id)                   
tablespace storetindx                             
storage(initial 15M next 10M) nologging; 


--delete independent lat and long indexes?
create index ire_lat_long on 
FA_REGULAR_RESULT(stn_latitude,stn_longitude)
tablespace storetindx
storage(initial 15M next 10M) nologging;


--MULTI-DIMENSIONAL INDEXES
--added 8-29-2003
create index ire_medium_lat_long on 
FA_REGULAR_RESULT(fk_act_medium,stn_latitude,stn_longitude)
tablespace storetindx
storage(initial 15m next 10m) nologging;


/** created new index with act medium 8-13
create index ire_date_lat_long on 
FA_REGULAR_RESULT(fk_date_act_start,stn_latitude,stn_longitude)
tablespace storetindx
storage(initial 15M next 10M) nologging;
**/

create index ire_date_lat_long_medium on 
FA_REGULAR_RESULT(fk_date_act_start,stn_latitude,stn_longitude,fk_act_medium)
tablespace storetindx
storage(initial 15M next 10M) nologging;

/** order of index changed on 2-27, significantly better performance
create index ire_lat_long_date_char on 
FA_REGULAR_RESULT(stn_latitude,stn_longitude,fk_date_act_start,fk_char)
tablespace storetindx
storage(initial 50m next 50m) nologging;
**/

/** created new index with act medium 8-13
create index ire_char_date_lat_long on 
FA_REGULAR_RESULT(fk_char,fk_date_act_start,stn_latitude,stn_longitude)
tablespace storetindx
storage(initial 15M next 10M) nologging;
**/

create index ire_char_date_lat_long_medium on 
FA_REGULAR_RESULT(fk_char,fk_date_act_start,stn_latitude,stn_longitude,fk_act_medium)
tablespace storetindx
storage(initial 15M next 10M) nologging;

/** created new index with act medium 8-13
create index ire_state_date_char on 
FA_REGULAR_RESULT(fk_geo_state,fk_date_act_start,fk_char)
tablespace storetindx
storage(initial 15M next 10M) nologging;
**/

create index ire_state_date_char_medium on 
FA_REGULAR_RESULT(fk_geo_state,fk_date_act_start,fk_char,fk_act_medium)
tablespace storetindx
storage(initial 15M next 10M) nologging;

/** created new index with act medium 8-13
create index ire_county_date_char on 
FA_REGULAR_RESULT(fk_geo_county,fk_date_act_start,fk_char)
tablespace storetindx
storage(initial 15M next 10M) nologging;
**/

create index ire_county_date_char_medium on 
FA_REGULAR_RESULT(fk_geo_county,fk_date_act_start,fk_char,fk_act_medium)
tablespace storetindx
storage(initial 15M next 10M) nologging;

create index ire_huc_date_char on 
FA_REGULAR_RESULT(hydrologic_unit_code,fk_date_act_start,fk_char)
tablespace storetindx
storage(initial 15M next 10M) nologging;

--added from performance_tuning script
create index ire_pk_date_char on 
FA_REGULAR_RESULT(pk_isn,fk_date_act_start,fk_char)
tablespace storetindx
storage(initial 20M next 10M) nologging;

create index ire_pk_char on 
FA_REGULAR_RESULT(pk_isn,fk_char)
tablespace storetindx
storage(initial 20M next 10M) nologging;

--Added 1-26 for SIR 1571
create index ire_stn_act_pt on FA_REGULAR_RESULT(fk_stn_act_pt)
tablespace storetindx
storage(initial 15M next 10M) nologging;

spool off;